﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0075_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$CreateThemesSettingsKey = "CreateThemesSettings"
$CreateThemesSettingsValue = 2
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $CreateThemesSettingsKey -Value $CreateThemesSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$CreateThemesSettingsKey registry key created value $CreateThemesSettingsValue "
} else {
    Log-Message -message "Checking value of $CreateThemesSettingsKey registry key expecting $CreateThemesSettingsValue"
    Try {
        $CreateThemesSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $CreateThemesSettingsKey
        if($CreateThemesSettingsCheck -ne $CreateThemesSettingsValue){
        Log-Message -message "$CreateThemesSettingsKey configured incorrect value: $CreateThemesSettingsCheck"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $CreateThemesSettingsKey -Value $CreateThemesSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $CreateThemesSettingsKey value: $CreateThemesSettingsValue"

        } else {
            Log-Message -message "$CreateThemesSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $CreateThemesSettingsKey -Value $CreateThemesSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $CreateThemesSettingsKey value: $CreateThemesSettingsValue"
    }
}